/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.Collection;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetCardInYourGraveyard;

class SuturedGhoulEffect
extends OneShotEffect {
    SuturedGhoulEffect() {
        super(Outcome.Benefit);
        this.staticText = "exile any number of creature cards from your graveyard";
    }

    private SuturedGhoulEffect(SuturedGhoulEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Permanent permanent = game.getPermanentEntering(source.getSourceId());
        if (permanent == null || controller == null) {
            return false;
        }
        if (!controller.getGraveyard().isEmpty()) {
            TargetCardInYourGraveyard target = new TargetCardInYourGraveyard(0, Integer.MAX_VALUE, (FilterCard)StaticFilters.FILTER_CARD_CREATURES_YOUR_GRAVEYARD);
            if (controller.chooseTarget(Outcome.Benefit, (Target)target, source, game)) {
                int count = 0;
                for (UUID uuid : target.getTargets()) {
                    Card card = controller.getGraveyard().get(uuid, game);
                    if (card == null) continue;
                    card.moveToExile(this.getId(), permanent.getIdName(), source, game);
                    permanent.imprint(card.getId(), game);
                    ++count;
                }
                CardsImpl cardsToExile = new CardsImpl((Collection)target.getTargets());
                controller.moveCards((Cards)cardsToExile, Zone.EXILED, source, game);
                String msg = count == 1 ? "1 card" : count + "cards";
                game.informPlayers(permanent.getLogName() + ": " + controller.getLogName() + " exiled " + msg);
            }
        } else {
            game.informPlayers(permanent.getLogName() + ": No cards in graveyard.");
        }
        return true;
    }

    public SuturedGhoulEffect copy() {
        return new SuturedGhoulEffect(this);
    }
}

