/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterPermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.card.OwnerIdPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class SwayOfTheStarsEffect
extends OneShotEffect {
    SwayOfTheStarsEffect() {
        super(Outcome.Neutral);
        this.staticText = "Each player shuffles their hand, graveyard, and all permanents they own into their library";
    }

    private SwayOfTheStarsEffect(SwayOfTheStarsEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            for (UUID playerId : game.getState().getPlayersInRange(controller.getId(), game)) {
                Player player = game.getPlayer(playerId);
                if (player == null) continue;
                player.moveCards(player.getHand(), Zone.LIBRARY, source, game);
                player.moveCards((Cards)player.getGraveyard(), Zone.LIBRARY, source, game);
                FilterPermanent filter = new FilterPermanent();
                filter.add((Predicate)new OwnerIdPredicate(playerId));
                CardsImpl toLib = new CardsImpl();
                for (Permanent permanent : game.getBattlefield().getActivePermanents(filter, controller.getId(), source, game)) {
                    toLib.add((Card)permanent);
                }
                player.shuffleCardsToLibrary((Cards)toLib, game, source);
            }
        }
        return true;
    }

    public SwayOfTheStarsEffect copy() {
        return new SwayOfTheStarsEffect(this);
    }
}

