/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.cards.s.SwindlersSchemeEffect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.stack.Spell;
import mage.players.Player;

class SwindlersSchemeOpponentCastTriggeredAbility
extends TriggeredAbilityImpl {
    SwindlersSchemeOpponentCastTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new SwindlersSchemeEffect(), true);
        this.setTriggerPhrase("Whenever an opponent casts a spell from their hand, ");
    }

    private SwindlersSchemeOpponentCastTriggeredAbility(SwindlersSchemeOpponentCastTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.SPELL_CAST;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        Player controller = game.getPlayer(this.getControllerId());
        if (controller == null || !controller.hasOpponent(event.getPlayerId(), game)) {
            return false;
        }
        Spell spell = game.getStack().getSpell(event.getTargetId());
        if (spell == null || spell.getFromZone() != Zone.HAND) {
            return false;
        }
        this.getEffects().setValue("spellCast", (Object)spell);
        return true;
    }

    public SwindlersSchemeOpponentCastTriggeredAbility copy() {
        return new SwindlersSchemeOpponentCastTriggeredAbility(this);
    }
}

