/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.common.delayed.AtTheBeginOfNextEndStepDelayedTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.cards.s.SwoopingPteranodonDamageEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.target.Target;
import mage.target.TargetPermanent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class SwoopingPteranodonCreateDelayedTriggerEffect
extends OneShotEffect {
    SwoopingPteranodonCreateDelayedTriggerEffect() {
        super(Outcome.Sacrifice);
        this.staticText = "At the beginning of the next end step, target land deals 3 damage to that creature.";
    }

    private SwoopingPteranodonCreateDelayedTriggerEffect(SwoopingPteranodonCreateDelayedTriggerEffect effect) {
        super((OneShotEffect)effect);
    }

    public SwoopingPteranodonCreateDelayedTriggerEffect copy() {
        return new SwoopingPteranodonCreateDelayedTriggerEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (permanent == null) {
            return false;
        }
        SwoopingPteranodonDamageEffect damageEffect = new SwoopingPteranodonDamageEffect(3);
        damageEffect.setTargetPointer((TargetPointer)new FixedTarget(permanent, game));
        damageEffect.setText("target land deals 3 damage to that creature.");
        AtTheBeginOfNextEndStepDelayedTriggeredAbility delayedAbility = new AtTheBeginOfNextEndStepDelayedTriggeredAbility((Effect)damageEffect);
        delayedAbility.addTarget((Target)new TargetPermanent((FilterPermanent)StaticFilters.FILTER_LAND));
        game.addDelayedTriggeredAbility((DelayedTriggeredAbility)delayedAbility, source);
        return true;
    }
}

