/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.CreateTokenEffect;
import mage.abilities.effects.common.MillCardsTargetEffect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.DamagedPlayerEvent;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.game.permanent.token.Token;
import mage.game.permanent.token.WolfToken;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class SwordOfBodyAndMindAbility
extends TriggeredAbilityImpl {
    public SwordOfBodyAndMindAbility() {
        super(Zone.BATTLEFIELD, (Effect)new CreateTokenEffect((Token)new WolfToken()));
        this.addEffect((Effect)new MillCardsTargetEffect(10));
    }

    private SwordOfBodyAndMindAbility(SwordOfBodyAndMindAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public SwordOfBodyAndMindAbility copy() {
        return new SwordOfBodyAndMindAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DAMAGED_PLAYER;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        DamagedPlayerEvent damageEvent = (DamagedPlayerEvent)event;
        Permanent p = game.getPermanent(event.getSourceId());
        if (damageEvent.isCombatDamage() && p != null && p.getAttachments().contains(this.getSourceId())) {
            this.getEffects().setTargetPointer((TargetPointer)new FixedTarget(event.getPlayerId()));
            return true;
        }
        return false;
    }

    public String getRule() {
        return "Whenever equipped creature deals combat damage to a player, you create a 2/2 green Wolf creature token and that player mills ten cards.";
    }
}

