/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class SwordOfHoursEffect
extends OneShotEffect {
    SwordOfHoursEffect() {
        super(Outcome.Benefit);
        this.staticText = "roll a d12. If the result is greater than the damage dealt or the result is 12, double the number of +1/+1 counters on that creature";
    }

    private SwordOfHoursEffect(SwordOfHoursEffect effect) {
        super((OneShotEffect)effect);
    }

    public SwordOfHoursEffect copy() {
        return new SwordOfHoursEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        int result = player.rollDice(this.outcome, source, game, 12);
        int damage = (Integer)this.getValue("damage");
        if (result != 12 && damage >= result) {
            return true;
        }
        Permanent sourcePermanent = source.getSourcePermanentOrLKI(game);
        if (sourcePermanent == null) {
            return true;
        }
        Permanent permanent = game.getPermanent(sourcePermanent.getAttachedTo());
        if (permanent == null) {
            return true;
        }
        permanent.addCounters(CounterType.P1P1.createInstance(permanent.getCounters(game).getCount(CounterType.P1P1)), source.getControllerId(), source, game);
        return true;
    }
}

