/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.counter.ProliferateEffect;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetControlledCreaturePermanent;

class SwordOfTruthAndJusticeEffect
extends OneShotEffect {
    SwordOfTruthAndJusticeEffect() {
        super(Outcome.Benefit);
        this.staticText = "put a +1/+1 counter on a creature you control, then proliferate. <i>(Choose any number of permanents and/or players, then give each another counter of each kind already there.)</i>";
    }

    private SwordOfTruthAndJusticeEffect(SwordOfTruthAndJusticeEffect effect) {
        super((OneShotEffect)effect);
    }

    public SwordOfTruthAndJusticeEffect copy() {
        return new SwordOfTruthAndJusticeEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent;
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        TargetControlledCreaturePermanent target = new TargetControlledCreaturePermanent();
        target.withNotTarget(true);
        if (player.choose(this.outcome, (Target)target, source, game) && (permanent = game.getPermanent(target.getFirstTarget())) != null) {
            permanent.addCounters(CounterType.P1P1.createInstance(), source.getControllerId(), source, game);
        }
        return new ProliferateEffect(true).apply(game, source);
    }
}

