/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import mage.constants.WatcherScope;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.watchers.Watcher;

class SylvanLibraryCardsDrawnThisTurnWatcher
extends Watcher {
    private final Map<UUID, Set<UUID>> cardsDrawnThisTurn = new HashMap<UUID, Set<UUID>>();

    public SylvanLibraryCardsDrawnThisTurnWatcher() {
        super(WatcherScope.GAME);
    }

    public void watch(GameEvent event, Game game) {
        if (event.getType() == GameEvent.EventType.DREW_CARD) {
            Set<UUID> cardsDrawn = this.getCardsDrawnThisTurn(event.getPlayerId());
            cardsDrawn.add(event.getTargetId());
            this.cardsDrawnThisTurn.put(event.getPlayerId(), cardsDrawn);
        }
    }

    public Set<UUID> getCardsDrawnThisTurn(UUID playerId) {
        return this.cardsDrawnThisTurn.getOrDefault(playerId, new LinkedHashSet());
    }

    public void reset() {
        super.reset();
        this.cardsDrawnThisTurn.clear();
    }
}

