/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.CreateTokenTargetEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.token.SylvanOfferingTreefolkToken;
import mage.game.permanent.token.Token;
import mage.players.Player;
import mage.target.common.TargetOpponent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;
import mage.util.CardUtil;

class SylvanOfferingEffect1
extends OneShotEffect {
    SylvanOfferingEffect1() {
        super(Outcome.Sacrifice);
        this.staticText = "Choose an opponent. You and that player each create an X/X green Treefolk creature token";
    }

    private SylvanOfferingEffect1(SylvanOfferingEffect1 effect) {
        super((OneShotEffect)effect);
    }

    public SylvanOfferingEffect1 copy() {
        return new SylvanOfferingEffect1(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            TargetOpponent target = new TargetOpponent(true);
            target.choose(Outcome.Sacrifice, source.getControllerId(), source.getSourceId(), source, game);
            Player opponent = game.getPlayer(target.getFirstTarget());
            if (opponent != null) {
                int xValue = (Integer)CardUtil.getSourceCostsTag((Game)game, (Ability)source, (String)"X", (Object)0);
                CreateTokenTargetEffect effect = new CreateTokenTargetEffect((Token)new SylvanOfferingTreefolkToken(xValue));
                effect.setTargetPointer((TargetPointer)new FixedTarget(controller.getId()));
                effect.apply(game, source);
                effect.setTargetPointer((TargetPointer)new FixedTarget(opponent.getId()));
                effect.apply(game, source);
                return true;
            }
        }
        return false;
    }
}

