/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.HashSet;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.CreateTokenEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.game.permanent.token.ExpansionSymbolToken;
import mage.game.permanent.token.Token;

class SymbolStatusEffect
extends OneShotEffect {
    SymbolStatusEffect() {
        super(Outcome.PutCreatureInPlay);
        this.staticText = "Create a 1/1 colorless Expansion-Symbol creature token for each different expansion symbol among permanents you control";
    }

    private SymbolStatusEffect(SymbolStatusEffect effect) {
        super((OneShotEffect)effect);
    }

    public SymbolStatusEffect copy() {
        return new SymbolStatusEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        HashSet<String> symbols = new HashSet<String>();
        for (Permanent permanent : game.getBattlefield().getAllActivePermanents(source.getControllerId())) {
            symbols.add(permanent.getExpansionSetCode());
        }
        return new CreateTokenEffect((Token)new ExpansionSymbolToken(), symbols.size()).apply(game, source);
    }
}

