/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.dynamicvalue.common.PartyCount;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class SynchronizedSpellcraftEffect
extends OneShotEffect {
    SynchronizedSpellcraftEffect() {
        super(Outcome.Benefit);
        this.staticText = "and X damage to that creature's controller, where X is the number of creatures in your party. " + PartyCount.getReminder();
    }

    private SynchronizedSpellcraftEffect(SynchronizedSpellcraftEffect effect) {
        super((OneShotEffect)effect);
    }

    public SynchronizedSpellcraftEffect copy() {
        return new SynchronizedSpellcraftEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        int partyCount = PartyCount.instance.calculate(game, source, (Effect)this);
        if (partyCount < 1) {
            return false;
        }
        Permanent permanent = game.getPermanentOrLKIBattlefield(source.getFirstTarget());
        if (permanent == null) {
            return false;
        }
        Player player = game.getPlayer(permanent.getControllerId());
        if (player == null) {
            return false;
        }
        return player.damage(partyCount, source.getSourceId(), source, game) > 0;
    }
}

