/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.combat.CantBlockTargetEffect;
import mage.constants.Duration;
import mage.constants.Zone;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;

class SyndicateEnforcerTriggeredAbility
extends TriggeredAbilityImpl {
    private static final Effect effect = new CantBlockTargetEffect(Duration.EndOfTurn);

    public SyndicateEnforcerTriggeredAbility() {
        super(Zone.BATTLEFIELD, effect, false);
    }

    private SyndicateEnforcerTriggeredAbility(SyndicateEnforcerTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public SyndicateEnforcerTriggeredAbility copy() {
        return new SyndicateEnforcerTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.COUNTERS_ADDED;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        Permanent permanent;
        return event.getData().equals(CounterType.BOUNTY.getName()) && (permanent = game.getPermanentOrLKIBattlefield(event.getTargetId())) != null;
    }

    public String getRule() {
        return "Whenever a bounty counter is placed on a creature an opponents controls, that creature can't block this turn.";
    }
}

