/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.Collection;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.cards.s.SynthesisPodCost;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;
import mage.util.CardUtil;

class SynthesisPodEffect
extends OneShotEffect {
    SynthesisPodEffect() {
        super(Outcome.Benefit);
        this.staticText = "target opponent reveals cards from the top of their library until they reveal a card with mana value equal to 1 plus the exiled spell's mana value. Exile that card, then that player shuffles. You may cast that exiled card without paying its mana cost";
    }

    private SynthesisPodEffect(SynthesisPodEffect effect) {
        super((OneShotEffect)effect);
    }

    public SynthesisPodEffect copy() {
        return new SynthesisPodEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Player opponent = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        Integer exiledSpellManaValue = CardUtil.castStream((Collection)source.getCosts(), SynthesisPodCost.class).map(SynthesisPodCost::getExiledSpellManaValue).findFirst().orElse(null);
        if (controller == null || opponent == null || exiledSpellManaValue == null) {
            return false;
        }
        CardsImpl cards = new CardsImpl();
        Card card = SynthesisPodEffect.getCard(exiledSpellManaValue, opponent, (Cards)cards, game);
        opponent.revealCards(source, (Cards)cards, game);
        if (card != null) {
            controller.moveCards(card, Zone.EXILED, source, game);
        }
        opponent.shuffleLibrary(source, game);
        if (card != null) {
            CardUtil.castSpellWithAttributesForFree((Player)controller, (Ability)source, (Game)game, (Card)card);
        }
        return true;
    }

    private static Card getCard(int exiledSpellManaValue, Player opponent, Cards cards, Game game) {
        for (Card card : opponent.getLibrary().getCards(game)) {
            cards.add(card);
            if (card.getManaValue() != exiledSpellManaValue + 1) continue;
            return card;
        }
        return null;
    }
}

