/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.LinkedHashSet;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;

class SyntheticDestinyDelayedEffect
extends OneShotEffect {
    protected int numberOfCards;

    public SyntheticDestinyDelayedEffect(int numberOfCards) {
        super(Outcome.PutCreatureInPlay);
        this.numberOfCards = numberOfCards;
        this.staticText = "reveal cards from the top of your library until you reveal that many creature cards, put all creature cards revealed this way onto the battlefield, then shuffle the rest of the revealed cards into your library";
    }

    private SyntheticDestinyDelayedEffect(SyntheticDestinyDelayedEffect effect) {
        super((OneShotEffect)effect);
        this.numberOfCards = effect.numberOfCards;
    }

    public SyntheticDestinyDelayedEffect copy() {
        return new SyntheticDestinyDelayedEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            CardsImpl revealed = new CardsImpl();
            LinkedHashSet<Card> creatureCards = new LinkedHashSet<Card>();
            for (Card card : controller.getLibrary().getCards(game)) {
                revealed.add(card);
                if (card.isCreature(game)) {
                    creatureCards.add(card);
                }
                if (creatureCards.size() < this.numberOfCards) continue;
                break;
            }
            controller.revealCards(source, (Cards)revealed, game);
            controller.moveCards(creatureCards, Zone.BATTLEFIELD, source, game);
            controller.shuffleLibrary(source, game);
            return true;
        }
        return false;
    }
}

