/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.ArrayList;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.game.permanent.token.ZombieToken;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetSacrifice;

class SyphonFleshEffect
extends OneShotEffect {
    SyphonFleshEffect() {
        super(Outcome.Sacrifice);
        this.staticText = "each other player sacrifices a creature. You create a 2/2 black Zombie creature token for each creature sacrificed this way.";
    }

    private SyphonFleshEffect(SyphonFleshEffect effect) {
        super((OneShotEffect)effect);
    }

    public SyphonFleshEffect copy() {
        return new SyphonFleshEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        ArrayList perms = new ArrayList();
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            int sacrificedAmount;
            for (UUID playerId : game.getState().getPlayersInRange(controller.getId(), game)) {
                TargetSacrifice target;
                Player player = game.getPlayer(playerId);
                if (player == null || playerId.equals(source.getControllerId()) || !(target = new TargetSacrifice((FilterPermanent)StaticFilters.FILTER_PERMANENT_CREATURE)).canChoose(player.getId(), source, game)) continue;
                player.choose(Outcome.Sacrifice, (Target)target, source, game);
                perms.addAll(target.getTargets());
            }
            for (UUID permID : perms) {
                Permanent permanent = game.getPermanent(permID);
                if (permanent == null) continue;
                permanent.sacrifice(source, game);
            }
            int n = sacrificedAmount = perms.isEmpty() ? 0 : perms.size();
            if (sacrificedAmount > 0) {
                ZombieToken token = new ZombieToken();
                token.putOntoBattlefield(sacrificedAmount, game, source, source.getControllerId());
            }
            return true;
        }
        return false;
    }
}

