/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.Optional;
import mage.MageItem;
import mage.MageObject;
import mage.abilities.TriggeredAbility;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.DestroyTargetEffect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.ZoneChangeEvent;
import mage.target.Target;
import mage.target.common.TargetNonlandPermanent;

class SyrVondamSunstarExemplarSecondTriggeredAbility
extends TriggeredAbilityImpl {
    SyrVondamSunstarExemplarSecondTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new DestroyTargetEffect());
        this.addTarget((Target)new TargetNonlandPermanent(0, 1));
        this.setTriggerPhrase("When {this} dies or is put into exile while its power is 4 or greater, ");
        this.setLeavesTheBattlefieldTrigger(true);
    }

    private SyrVondamSunstarExemplarSecondTriggeredAbility(SyrVondamSunstarExemplarSecondTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public SyrVondamSunstarExemplarSecondTriggeredAbility copy() {
        return new SyrVondamSunstarExemplarSecondTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ZONE_CHANGE;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean checkTrigger(GameEvent event, Game game) {
        ZoneChangeEvent zEvent = (ZoneChangeEvent)event;
        if (!Zone.BATTLEFIELD.match(zEvent.getFromZone())) return false;
        if (!Zone.GRAVEYARD.match(zEvent.getToZone())) {
            if (!Zone.EXILED.match(zEvent.getToZone())) return false;
        }
        if (!Optional.ofNullable(zEvent).map(ZoneChangeEvent::getTarget).filter(permanent -> permanent.getPower().getValue() >= 4).map(MageItem::getId).filter(this.getSourceId()::equals).isPresent()) return false;
        return true;
    }

    public boolean isInUseableZone(Game game, MageObject sourceObject, GameEvent event) {
        return TriggeredAbilityImpl.isInUseableZoneDiesTrigger((TriggeredAbility)this, (MageObject)sourceObject, (GameEvent)event, (Game)game);
    }
}

