/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.common.delayed.AtTheBeginOfNextEndStepDelayedTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.counter.RemoveCounterTargetEffect;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class SystemsOverrideEffect
extends OneShotEffect {
    SystemsOverrideEffect() {
        super(Outcome.Benefit);
        this.staticText = "If it's a Spacecraft, put ten charge counters on it. If you do, remove ten charge counters from it at the beginning of the next end step.";
    }

    private SystemsOverrideEffect(SystemsOverrideEffect effect) {
        super((OneShotEffect)effect);
    }

    public SystemsOverrideEffect copy() {
        return new SystemsOverrideEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (permanent == null || !permanent.hasSubtype(SubType.SPACECRAFT, game) || !permanent.addCounters(CounterType.CHARGE.createInstance(10), source, game)) {
            return false;
        }
        game.addDelayedTriggeredAbility((DelayedTriggeredAbility)new AtTheBeginOfNextEndStepDelayedTriggeredAbility((Effect)new RemoveCounterTargetEffect(CounterType.CHARGE.createInstance(10)).setTargetPointer((TargetPointer)new FixedTarget(permanent, game))), source);
        return true;
    }
}

