/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.Collection;
import java.util.Objects;
import java.util.stream.Collectors;
import mage.MageInt;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.token.BreedingPitThrullToken;
import mage.players.Player;

class SzatsWillEffect
extends OneShotEffect {
    SzatsWillEffect() {
        super(Outcome.Benefit);
        this.staticText = "exile all opponents' graveyards, then create X 0/1 black Thrull creature tokens, where X is the greatest power among creature cards exiled this way";
    }

    private SzatsWillEffect(SzatsWillEffect effect) {
        super((OneShotEffect)effect);
    }

    public SzatsWillEffect copy() {
        return new SzatsWillEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        CardsImpl cards = new CardsImpl((Collection)game.getOpponents(source.getControllerId(), true).stream().map(arg_0 -> ((Game)game).getPlayer(arg_0)).filter(Objects::nonNull).map(Player::getGraveyard).flatMap(Collection::stream).collect(Collectors.toSet()));
        player.moveCards((Cards)cards, Zone.EXILED, source, game);
        cards.removeIf(uuid -> game.getState().getZone(uuid) != Zone.EXILED);
        int maxPower = cards.getCards(game).stream().filter(Objects::nonNull).filter(card -> card.isCreature(game)).map(MageObject::getPower).mapToInt(MageInt::getValue).max().orElse(0);
        if (maxPower > 0) {
            new BreedingPitThrullToken().putOntoBattlefield(maxPower, game, source, source.getControllerId());
        }
        return true;
    }
}

