/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import mage.abilities.LoyaltyAbility;
import mage.constants.WatcherScope;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.stack.StackObject;
import mage.watchers.Watcher;

class ActivatedLoyaltyAbilityWatcher
extends Watcher {
    private final Set<UUID> playerIds = new HashSet<UUID>();

    public ActivatedLoyaltyAbilityWatcher() {
        super(WatcherScope.GAME);
    }

    public void watch(GameEvent event, Game game) {
        if (event.getType() != GameEvent.EventType.ACTIVATED_ABILITY) {
            return;
        }
        StackObject stackObject = game.getStack().getStackObject(event.getTargetId());
        if (stackObject != null && stackObject.getStackAbility() != null && stackObject.getStackAbility() instanceof LoyaltyAbility) {
            this.playerIds.add(stackObject.getControllerId());
        }
    }

    public void reset() {
        this.playerIds.clear();
    }

    public boolean activatedLoyaltyAbility(UUID playerId) {
        return this.playerIds.contains(playerId);
    }
}

