/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.abilities.Ability;
import mage.abilities.dynamicvalue.common.PermanentsOnBattlefieldCount;
import mage.abilities.effects.ContinuousRuleModifyingEffectImpl;
import mage.abilities.effects.Effect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledPermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.NamePredicate;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.players.Player;

class CheeseStandsAloneContinuousEffect
extends ContinuousRuleModifyingEffectImpl {
    private static final FilterControlledPermanent filter = new FilterControlledPermanent();
    private boolean wonAlready = false;

    public CheeseStandsAloneContinuousEffect() {
        super(Duration.EndOfGame, Outcome.Benefit, false, false);
        this.staticText = "When you control no permanents other than {this} and have no cards in hand, you win the game";
    }

    private CheeseStandsAloneContinuousEffect(CheeseStandsAloneContinuousEffect effect) {
        super((ContinuousRuleModifyingEffectImpl)effect);
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return true;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        int numberPerms;
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null && controller.getHand().isEmpty() && (numberPerms = new PermanentsOnBattlefieldCount((FilterPermanent)new FilterControlledPermanent()).calculate(game, source, (Effect)this)) == 1 && game.getBattlefield().containsControlled((FilterPermanent)filter, source, game, 1) && !this.wonAlready) {
            this.wonAlready = true;
            controller.won(game);
        }
        return false;
    }

    public CheeseStandsAloneContinuousEffect copy() {
        return new CheeseStandsAloneContinuousEffect(this);
    }

    static {
        filter.add((Predicate)new NamePredicate("The Cheese Stands Alone"));
    }
}

