/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import java.util.Set;
import mage.MageObject;
import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousRuleModifyingEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.PhaseStep;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.watchers.common.AttackedLastTurnWatcher;

class DontUntapIfAttackedLastTurnEnchantedEffect
extends ContinuousRuleModifyingEffectImpl {
    DontUntapIfAttackedLastTurnEnchantedEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Detriment, false, true);
        this.staticText = "Enchanted creature doesn't untap during its controller's untap step if it attacked during its controller's last turn";
    }

    private DontUntapIfAttackedLastTurnEnchantedEffect(DontUntapIfAttackedLastTurnEnchantedEffect effect) {
        super((ContinuousRuleModifyingEffectImpl)effect);
    }

    public DontUntapIfAttackedLastTurnEnchantedEffect copy() {
        return new DontUntapIfAttackedLastTurnEnchantedEffect(this);
    }

    public String getInfoMessage(Ability source, GameEvent event, Game game) {
        Permanent enchanted;
        Permanent enchantment = game.getPermanent(source.getSourceId());
        if (enchantment != null && enchantment.getAttachedTo() != null && (enchanted = game.getPermanent(enchantment.getAttachedTo())) != null) {
            return enchanted.getLogName() + " doesn't untap during its controller's untap step (" + enchantment.getLogName() + ')';
        }
        return null;
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.UNTAP;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        MageObjectReference mor;
        Set attackingCreatures;
        AttackedLastTurnWatcher watcher;
        Permanent permanent;
        Permanent enchantment;
        return game.getTurnStepType() == PhaseStep.UNTAP && (enchantment = game.getPermanent(source.getSourceId())) != null && enchantment.getAttachedTo() != null && event.getTargetId().equals(enchantment.getAttachedTo()) && (permanent = game.getPermanent(enchantment.getAttachedTo())) != null && permanent.isControlledBy(game.getActivePlayerId()) && (watcher = (AttackedLastTurnWatcher)game.getState().getWatcher(AttackedLastTurnWatcher.class)) != null && (attackingCreatures = watcher.getAttackedLastTurnCreatures(permanent.getControllerId())).contains(mor = new MageObjectReference((MageObject)permanent, game));
    }
}

