/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import java.util.UUID;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.condition.Condition;
import mage.cards.Card;
import mage.cards.ModalDoubleFacedCardHalf;
import mage.cards.SpellOptionCard;
import mage.cards.SplitCardHalf;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.stack.Spell;

enum ExiledCreatureSpellCondition implements Condition
{
    instance;


    public boolean apply(Game game, Ability source) {
        MageObject object = game.getObject(source);
        if (object instanceof SplitCardHalf || object instanceof SpellOptionCard || object instanceof ModalDoubleFacedCardHalf) {
            UUID mainCardId = ((Card)object).getMainCard().getId();
            object = game.getObject(mainCardId);
        }
        if (object instanceof Spell) {
            Spell spell = (Spell)object;
            return Zone.EXILED.equals((Object)spell.getFromZone()) && spell.isCreature();
        }
        if (object instanceof Card) {
            Card card = (Card)object;
            return game.getExile().getCard(card.getId(), game) != null && card.isCreature();
        }
        return false;
    }
}

