/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.search.SearchLibraryGraveyardPutOntoBattlefieldEffect;
import mage.constants.ComparisonType;
import mage.constants.Outcome;
import mage.filter.FilterCard;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.filter.common.FilterCreatureCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.ManaValuePredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetSacrifice;

class HungerTideSacrificeSearchEffect
extends OneShotEffect {
    HungerTideSacrificeSearchEffect() {
        super(Outcome.Benefit);
        this.staticText = "Sacrifice any number of creatures. Search your library and/or graveyard for a creature card with mana value less than or equal to the number of creatures sacrificed this way and put it onto the battlefield. If you search your library this way, shuffle.";
    }

    private HungerTideSacrificeSearchEffect(HungerTideSacrificeSearchEffect effect) {
        super((OneShotEffect)effect);
    }

    public HungerTideSacrificeSearchEffect copy() {
        return new HungerTideSacrificeSearchEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        int amount = 0;
        TargetSacrifice sacrifices = new TargetSacrifice(0, Integer.MAX_VALUE, (FilterPermanent)StaticFilters.FILTER_PERMANENT_CREATURES);
        if (controller.choose(Outcome.Sacrifice, (Target)sacrifices, source, game)) {
            for (UUID uuid : sacrifices.getTargets()) {
                Permanent creature = game.getPermanent(uuid);
                if (creature == null) continue;
                creature.sacrifice(source, game);
                ++amount;
            }
        }
        FilterCreatureCard filter = new FilterCreatureCard();
        filter.add((Predicate)new ManaValuePredicate(ComparisonType.OR_LESS, amount));
        SearchLibraryGraveyardPutOntoBattlefieldEffect searchEffect = new SearchLibraryGraveyardPutOntoBattlefieldEffect((FilterCard)filter);
        return searchEffect.apply(game, source);
    }
}

