/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import mage.ApprovingObject;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.SpellAbility;
import mage.abilities.costs.Costs;
import mage.abilities.costs.CostsImpl;
import mage.abilities.costs.common.DiscardCardCost;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;
import mage.util.CardUtil;

class InfamousCruelclawEffect
extends OneShotEffect {
    InfamousCruelclawEffect() {
        super(Outcome.PlayForFree);
        this.staticText = "exile cards from the top of your library until you exile a nonland card. You may cast that card by discarding a card rather than paying its mana cost.";
    }

    private InfamousCruelclawEffect(InfamousCruelclawEffect effect) {
        super((OneShotEffect)effect);
    }

    public InfamousCruelclawEffect copy() {
        return new InfamousCruelclawEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null || !controller.getLibrary().hasCards()) {
            return false;
        }
        for (Card card : controller.getLibrary().getCards(game)) {
            Card faceCard;
            controller.moveCards(card, Zone.EXILED, source, game);
            if (card.isLand(game)) continue;
            List castableComponents = CardUtil.getCastableComponents((Card)card, null, (Ability)source, (Player)controller, (Game)game, null, (boolean)false);
            if (castableComponents.isEmpty()) break;
            String partsInfo = castableComponents.stream().map(MageObject::getLogName).collect(Collectors.joining(" or "));
            if (!controller.chooseUse(Outcome.PlayForFree, "Cast spell by discarding a card instead of mana (" + partsInfo + ")?", source, game)) break;
            castableComponents.forEach(partCard -> {
                Boolean cfr_ignored_0 = (Boolean)game.getState().setValue("PlayFromNotOwnHandZone" + partCard.getId(), (Object)Boolean.TRUE);
            });
            SpellAbility chosenAbility = controller.chooseAbilityForCast(card, game, true);
            if (chosenAbility != null && (faceCard = game.getCard(chosenAbility.getSourceId())) != null) {
                CostsImpl newCosts = new CostsImpl();
                newCosts.add((Object)new DiscardCardCost());
                newCosts.addAll((Collection)chosenAbility.getCosts());
                controller.setCastSourceIdWithAlternateMana(faceCard.getId(), null, (Costs)newCosts);
                controller.cast(chosenAbility, game, true, new ApprovingObject(source, game));
            }
            castableComponents.forEach(partCard -> game.getState().setValue("PlayFromNotOwnHandZone" + partCard.getId(), null));
            break;
        }
        return true;
    }
}

