/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import java.util.Locale;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.choices.Choice;
import mage.choices.ChoiceColor;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class TabletOfTheGuildsEntersBattlefieldEffect
extends OneShotEffect {
    TabletOfTheGuildsEntersBattlefieldEffect() {
        super(Outcome.BoostCreature);
        this.staticText = "choose two colors";
    }

    private TabletOfTheGuildsEntersBattlefieldEffect(TabletOfTheGuildsEntersBattlefieldEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        Permanent permanent = game.getPermanentEntering(source.getSourceId());
        if (player != null && permanent != null) {
            ChoiceColor colorChoice = new ChoiceColor();
            colorChoice.setMessage("Choose the first color");
            if (!player.choose(Outcome.GainLife, (Choice)colorChoice, game)) {
                return false;
            }
            game.getState().setValue(permanent.getId() + "_color1", (Object)colorChoice.getColor().toString());
            String colors = colorChoice.getChoice().toLowerCase(Locale.ENGLISH) + " and ";
            colorChoice.getChoices().remove(colorChoice.getChoice());
            colorChoice.setMessage("Choose the second color");
            if (!player.choose(Outcome.GainLife, (Choice)colorChoice, game) && player.canRespond()) {
                return false;
            }
            game.getState().setValue(permanent.getId() + "_color2", (Object)colorChoice.getColor().toString());
            colors = colors + colorChoice.getChoice().toLowerCase(Locale.ENGLISH);
            game.informPlayers(permanent.getName() + ": " + player.getLogName() + " has chosen " + colors);
            return true;
        }
        return false;
    }

    public TabletOfTheGuildsEntersBattlefieldEffect copy() {
        return new TabletOfTheGuildsEntersBattlefieldEffect(this);
    }
}

