/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.GainControlTargetEffect;
import mage.cards.t.TahngarthFirstMatePermanentPredicate;
import mage.cards.t.TahngarthFirstMatePlayerPredicate;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.filter.common.FilterPlayerOrPlaneswalker;
import mage.filter.predicate.Predicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetPlayerOrPlaneswalker;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class TahngarthFirstMateEffect
extends OneShotEffect {
    private static final FilterPlayerOrPlaneswalker filter = new FilterPlayerOrPlaneswalker("player or planeswalker active player is attacking");

    TahngarthFirstMateEffect() {
        super(Outcome.Benefit);
    }

    private TahngarthFirstMateEffect(TahngarthFirstMateEffect effect) {
        super((OneShotEffect)effect);
    }

    public TahngarthFirstMateEffect copy() {
        return new TahngarthFirstMateEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Player player = game.getPlayer(game.getActivePlayerId());
        Permanent permanent = game.getPermanent(source.getSourceId());
        if (controller == null || player == null || permanent == null) {
            return false;
        }
        TargetPlayerOrPlaneswalker target = new TargetPlayerOrPlaneswalker(filter);
        target.withNotTarget(true);
        if (!controller.choose(this.outcome, (Target)target, source, game)) {
            return false;
        }
        GainControlTargetEffect effect = new GainControlTargetEffect(Duration.EndOfCombat, player.getId());
        effect.setTargetPointer((TargetPointer)new FixedTarget(permanent, game));
        game.addEffect((ContinuousEffect)effect, source);
        game.processAction();
        return game.getCombat().addAttackerToCombat(permanent.getId(), target.getFirstTarget(), game);
    }

    static {
        filter.getPlayerFilter().add((Predicate)TahngarthFirstMatePlayerPredicate.instance);
        filter.getPermanentFilter().add((Predicate)TahngarthFirstMatePermanentPredicate.instance);
    }
}

