/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.keyword.SuspendAbility;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.stack.Spell;
import mage.players.Player;

class TaigamMasterOpportunistEffect
extends OneShotEffect {
    public TaigamMasterOpportunistEffect() {
        super(Outcome.Copy);
        this.staticText = "copy it, then exile the spell you cast with four time counters on it. If it doesn't have suspend, it gains suspend.";
    }

    public TaigamMasterOpportunistEffect(TaigamMasterOpportunistEffect effect) {
        super((OneShotEffect)effect);
    }

    public TaigamMasterOpportunistEffect copy() {
        return new TaigamMasterOpportunistEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Spell spell = (Spell)this.getValue("spellCast");
        if (controller == null || spell == null) {
            return false;
        }
        spell.createCopyOnStack(game, source, source.getControllerId(), false);
        Card card = spell.getMainCard();
        controller.moveCards(card, Zone.EXILED, source, game);
        SuspendAbility.addTimeCountersAndSuspend((Card)card, (int)4, (Ability)source, (Game)game);
        return true;
    }
}

