/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.players.Player;

class TaintedRemedyReplacementEffect
extends ReplacementEffectImpl {
    TaintedRemedyReplacementEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Benefit);
        this.staticText = "If an opponent would gain life, that player loses that much life instead";
    }

    private TaintedRemedyReplacementEffect(TaintedRemedyReplacementEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public TaintedRemedyReplacementEffect copy() {
        return new TaintedRemedyReplacementEffect(this);
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.GAIN_LIFE;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            return controller.hasOpponent(event.getPlayerId(), game);
        }
        return false;
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        Player opponent = game.getPlayer(event.getPlayerId());
        if (opponent != null) {
            opponent.loseLife(event.getAmount(), game, source, false);
        }
        return true;
    }
}

