/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.t.TakklemaggotNonAuraEffect;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.permanent.CanBeEnchantedByPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetImpl;
import mage.target.TargetPermanent;
import mage.util.CardUtil;

class TakklemaggotEffect
extends OneShotEffect {
    TakklemaggotEffect() {
        super(Outcome.PutCardInPlay);
        this.staticText = "that creature's controller chooses a creature that {this} could enchant. If the player does, return {this} to the battlefield under your control attached to that creature. If they don't, return {this} to the battlefield under your control as a non-Aura enchantment. It loses \"enchant creature\" and gains \"At the beginning of that player's upkeep, {this} deals 1 damage to that player.\"";
    }

    private TakklemaggotEffect(TakklemaggotEffect effect) {
        super((OneShotEffect)effect);
    }

    public TakklemaggotEffect copy() {
        return new TakklemaggotEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Player player = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        Card auraCard = game.getCard(source.getSourceId());
        if (controller == null || player == null || auraCard == null) {
            return false;
        }
        FilterCreaturePermanent filter = new FilterCreaturePermanent();
        filter.add((Predicate)new CanBeEnchantedByPredicate((MageObject)auraCard));
        TargetImpl target = new TargetPermanent((FilterPermanent)filter).withNotTarget(true);
        if (!game.getBattlefield().getActivePermanents((FilterPermanent)filter, player.getId(), source, game).isEmpty() && player.choose(this.outcome, (Target)target, source, game)) {
            Permanent creature = game.getPermanent(target.getFirstTarget());
            if (creature == null) {
                return false;
            }
            game.getState().setValue("attachTo:" + auraCard.getId(), (Object)creature);
            controller.moveCards(auraCard, Zone.BATTLEFIELD, source, game);
            creature.addAttachment(auraCard.getId(), source, game);
        } else {
            game.addEffect((ContinuousEffect)new TakklemaggotNonAuraEffect(player.getId()), source);
            controller.moveCards(auraCard, Zone.BATTLEFIELD, source, game);
            auraCard.addInfo("chosen player", CardUtil.addToolTipMarkTags((String)("Chosen player: " + player.getLogName())), game);
        }
        return true;
    }
}

