/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.abilities.Ability;
import mage.abilities.common.delayed.ReflexiveTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.counter.AddCountersTargetEffect;
import mage.cards.Cards;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.counters.CounterType;
import mage.filter.FilterPermanent;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetPermanent;

class TalionsMessengerEffect
extends OneShotEffect {
    private static final FilterPermanent filter = new FilterPermanent(SubType.FAERIE, "Faerie you control");

    TalionsMessengerEffect() {
        super(Outcome.Benefit);
        this.staticText = "draw a card, then discard a card. When you discard a card this way, put a +1/+1 counter on target Faerie you control";
    }

    private TalionsMessengerEffect(TalionsMessengerEffect effect) {
        super((OneShotEffect)effect);
    }

    public TalionsMessengerEffect copy() {
        return new TalionsMessengerEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        controller.drawCards(1, source, game);
        Cards discard = controller.discard(1, false, false, source, game);
        if (!discard.isEmpty()) {
            ReflexiveTriggeredAbility reflexive = new ReflexiveTriggeredAbility((Effect)new AddCountersTargetEffect(CounterType.P1P1.createInstance()), false);
            reflexive.addTarget((Target)new TargetPermanent(filter));
            game.fireReflexiveTriggeredAbility(reflexive, source);
        }
        return true;
    }
}

