/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import java.util.List;
import mage.MageObjectReference;
import mage.abilities.BatchTriggeredAbility;
import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.DrawCardSourceControllerEffect;
import mage.constants.Duration;
import mage.game.Game;
import mage.game.events.BatchEvent;
import mage.game.events.DamagedBatchBySourceEvent;
import mage.game.events.DamagedEvent;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;

class TamiyoFieldResearcherDelayedTriggeredAbility
extends DelayedTriggeredAbility
implements BatchTriggeredAbility<DamagedEvent> {
    private final int startingTurn;
    private final List<MageObjectReference> creatures;

    TamiyoFieldResearcherDelayedTriggeredAbility(List<MageObjectReference> creatures, int startingTurn) {
        super((Effect)new DrawCardSourceControllerEffect(1, true), Duration.Custom, false);
        this.creatures = creatures;
        this.startingTurn = startingTurn;
        this.setTriggerPhrase("Until your next turn, whenever either of those creatures deals combat damage, ");
    }

    private TamiyoFieldResearcherDelayedTriggeredAbility(TamiyoFieldResearcherDelayedTriggeredAbility ability) {
        super((DelayedTriggeredAbility)ability);
        this.creatures = ability.creatures;
        this.startingTurn = ability.startingTurn;
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DAMAGED_BATCH_BY_SOURCE;
    }

    public boolean checkEvent(DamagedEvent event, Game game) {
        if (!event.isCombatDamage() || event.getAmount() <= 0) {
            return false;
        }
        Permanent permanent = game.getPermanentOrLKIBattlefield(event.getSourceId());
        if (permanent == null) {
            return false;
        }
        return this.creatures.contains(new MageObjectReference(permanent.getId(), game));
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        return !this.getFilteredEvents((BatchEvent)((DamagedBatchBySourceEvent)event), game).isEmpty();
    }

    public boolean isInactive(Game game) {
        return game.isActivePlayer(this.getControllerId()) && game.getTurnNum() != this.startingTurn;
    }

    public TamiyoFieldResearcherDelayedTriggeredAbility copy() {
        return new TamiyoFieldResearcherDelayedTriggeredAbility(this);
    }
}

