/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.game.Game;
import mage.game.permanent.Permanent;

class TamiyosCompleationLoseAbilitiesEffect
extends ContinuousEffectImpl {
    TamiyosCompleationLoseAbilitiesEffect() {
        super(Duration.WhileOnBattlefield, Layer.AbilityAddingRemovingEffects_6, SubLayer.NA, Outcome.LoseAbility);
        this.staticText = "Enchanted permanent loses all abilities";
    }

    private TamiyosCompleationLoseAbilitiesEffect(TamiyosCompleationLoseAbilitiesEffect effect) {
        super((ContinuousEffectImpl)effect);
    }

    public TamiyosCompleationLoseAbilitiesEffect copy() {
        return new TamiyosCompleationLoseAbilitiesEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent enchanted;
        Permanent enchantment = source.getSourcePermanentIfItStillExists(game);
        if (enchantment != null && (enchanted = game.getPermanent(enchantment.getAttachedTo())) != null) {
            enchanted.removeAllAbilities(source.getSourceId(), game);
            return true;
        }
        return false;
    }
}

