/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import java.util.ArrayList;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.PhaseOutAllEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledLandPermanent;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class TaniwhaEffect
extends OneShotEffect {
    TaniwhaEffect() {
        super(Outcome.Detriment);
        this.staticText = "all lands you control phase out";
    }

    private TaniwhaEffect(TaniwhaEffect effect) {
        super((OneShotEffect)effect);
    }

    public TaniwhaEffect copy() {
        return new TaniwhaEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            ArrayList<UUID> permIds = new ArrayList<UUID>();
            for (Permanent permanent : game.getBattlefield().getActivePermanents((FilterPermanent)new FilterControlledLandPermanent(), controller.getId(), game)) {
                permIds.add(permanent.getId());
            }
            return new PhaseOutAllEffect(permIds).apply(game, source);
        }
        return false;
    }
}

