/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.ObjectColor;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.abilities.keyword.WarpAbility;
import mage.cards.Card;
import mage.constants.CardType;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.filter.FilterCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.filter.predicate.mageobject.ColorPredicate;
import mage.game.Game;
import mage.players.Player;

class TannukSteadfastSecondEffect
extends ContinuousEffectImpl {
    private static final FilterCard filter = new FilterCard();

    TannukSteadfastSecondEffect() {
        super(Duration.WhileOnBattlefield, Layer.AbilityAddingRemovingEffects_6, SubLayer.NA, Outcome.AddAbility);
        this.staticText = "artifact cards and red creature cards in your hand have warp {2}{R}";
    }

    private TannukSteadfastSecondEffect(TannukSteadfastSecondEffect effect) {
        super((ContinuousEffectImpl)effect);
    }

    public TannukSteadfastSecondEffect copy() {
        return new TannukSteadfastSecondEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        for (Card card : controller.getHand().getCards(filter, game)) {
            game.getState().addOtherAbility(card, (Ability)new WarpAbility(card, "{2}{R}"));
        }
        return true;
    }

    static {
        filter.add(Predicates.or((Predicate)CardType.ARTIFACT.getPredicate(), (Predicate)Predicates.and((Predicate)new ColorPredicate(ObjectColor.RED), (Predicate)CardType.CREATURE.getPredicate())));
    }
}

