/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import java.util.Optional;
import mage.MageInt;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Controllable;
import mage.game.Game;
import mage.game.events.GameEvent;

class TapestryWardenEffect
extends ReplacementEffectImpl {
    TapestryWardenEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Benefit);
        this.staticText = "each creature you control with toughness greater than its power stations permanents using its toughness rather than its power";
    }

    private TapestryWardenEffect(TapestryWardenEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public TapestryWardenEffect copy() {
        return new TapestryWardenEffect(this);
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.STATION_PERMANENT;
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        Optional.ofNullable(event).map(GameEvent::getTargetId).map(arg_0 -> ((Game)game).getPermanent(arg_0)).map(MageObject::getToughness).map(MageInt::getValue).ifPresent(arg_0 -> ((GameEvent)event).setAmount(arg_0));
        return false;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        return Optional.ofNullable(event).map(GameEvent::getTargetId).map(arg_0 -> ((Game)game).getPermanent(arg_0)).filter(permanent -> permanent.getPower().getValue() < permanent.getToughness().getValue()).map(Controllable::getControllerId).filter(arg_0 -> ((Ability)source).isControlledBy(arg_0)).isPresent();
    }
}

