/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.RequirementEffect;
import mage.constants.Duration;
import mage.constants.TurnPhase;
import mage.game.Game;
import mage.game.permanent.Permanent;

class TauntEffect
extends RequirementEffect {
    TauntEffect() {
        super(Duration.Custom);
        this.staticText = "During target player's next turn, creatures that player controls attack you if able";
    }

    private TauntEffect(TauntEffect effect) {
        super((RequirementEffect)effect);
    }

    public TauntEffect copy() {
        return new TauntEffect(this);
    }

    public boolean applies(Permanent permanent, Ability source, Game game) {
        return permanent.isControlledBy(this.getTargetPointer().getFirst(game, source));
    }

    public boolean isInactive(Ability source, Game game) {
        return game.getTurnPhaseType() == TurnPhase.END && this.isYourNextTurn(game);
    }

    public UUID mustAttackDefender(Ability source, Game game) {
        return source.getControllerId();
    }

    public boolean mustAttack(Game game) {
        return true;
    }

    public boolean mustBlock(Game game) {
        return false;
    }
}

