/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import java.util.Collection;
import java.util.stream.Stream;
import mage.abilities.Ability;
import mage.abilities.costs.common.ExileFromGraveCost;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.CreateTokenCopyTargetEffect;
import mage.cards.Card;
import mage.constants.CardType;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.game.permanent.PermanentCard;
import mage.util.CardUtil;

class TawnosSolemnSurvivorEffect
extends OneShotEffect {
    TawnosSolemnSurvivorEffect() {
        super(Outcome.Benefit);
        this.staticText = "create a token that's a copy of the exiled card, except it's an artifact in addition to its other types";
    }

    private TawnosSolemnSurvivorEffect(TawnosSolemnSurvivorEffect effect) {
        super((OneShotEffect)effect);
    }

    public TawnosSolemnSurvivorEffect copy() {
        return new TawnosSolemnSurvivorEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Card card = CardUtil.castStream((Stream)source.getCosts().stream(), ExileFromGraveCost.class).map(ExileFromGraveCost::getExiledCards).flatMap(Collection::stream).findFirst().orElse(null);
        if (card == null) {
            return false;
        }
        PermanentCard permanent = new PermanentCard(CardUtil.getDefaultCardSideForBattlefield((Game)game, (Card)card), source.getControllerId(), game);
        return new CreateTokenCopyTargetEffect(null, CardType.ARTIFACT, false).setSavedPermanent((Permanent)permanent).apply(game, source);
    }
}

