/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.keyword.DiscoverEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.stack.Spell;
import mage.players.Player;

class TecutlanTheSearingRiftEffect
extends OneShotEffect {
    TecutlanTheSearingRiftEffect() {
        super(Outcome.Benefit);
        this.staticText = "discover X, where X is that spell's mana value";
    }

    private TecutlanTheSearingRiftEffect(TecutlanTheSearingRiftEffect effect) {
        super((OneShotEffect)effect);
    }

    public TecutlanTheSearingRiftEffect copy() {
        return new TecutlanTheSearingRiftEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        Spell spell = game.getSpellOrLKIStack(this.getTargetPointer().getFirst(game, source));
        int mv = spell == null ? 0 : Math.max(0, spell.getManaValue());
        DiscoverEffect.doDiscover((Player)controller, (int)mv, (Game)game, (Ability)source);
        return true;
    }
}

