/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.common.delayed.ReflexiveTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.ShuffleIntoLibraryTargetEffect;
import mage.constants.ComparisonType;
import mage.constants.Outcome;
import mage.constants.TargetController;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.filter.common.FilterNonlandPermanent;
import mage.filter.predicate.ObjectSourcePlayerPredicate;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.ManaValuePredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetPermanent;

class TeferiAkosaOfZhalfirEffect
extends OneShotEffect {
    TeferiAkosaOfZhalfirEffect() {
        super(Outcome.Benefit);
        this.staticText = "tap any number of untapped creatures you control. When you do, shuffle target nonland permanent an opponent controls with mana value X or less into its owner's library, where X is the number of creatures tapped this way";
    }

    private TeferiAkosaOfZhalfirEffect(TeferiAkosaOfZhalfirEffect effect) {
        super((OneShotEffect)effect);
    }

    public TeferiAkosaOfZhalfirEffect copy() {
        return new TeferiAkosaOfZhalfirEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        TargetPermanent target = new TargetPermanent(0, Integer.MAX_VALUE, (FilterPermanent)StaticFilters.FILTER_CONTROLLED_UNTAPPED_CREATURES, true);
        player.choose(Outcome.Tap, (Target)target, source, game);
        int count = 0;
        for (UUID targetId : target.getTargets()) {
            Permanent permanent = game.getPermanent(targetId);
            if (permanent == null || !permanent.tap(source, game)) continue;
            ++count;
        }
        FilterNonlandPermanent filter = new FilterNonlandPermanent("nonland permanent an opponent controls with mana value " + count + " or less");
        filter.add((ObjectSourcePlayerPredicate)TargetController.OPPONENT.getControllerPredicate());
        filter.add((Predicate)new ManaValuePredicate(ComparisonType.FEWER_THAN, count + 1));
        ReflexiveTriggeredAbility ability = new ReflexiveTriggeredAbility((Effect)new ShuffleIntoLibraryTargetEffect().setText("shuffle target nonland permanent an opponent controls with mana value X or less into its owner's library, where X is the number of creatures tapped this way"), false);
        ability.addTarget((Target)new TargetPermanent((FilterPermanent)filter));
        game.fireReflexiveTriggeredAbility(ability, source);
        return true;
    }
}

