/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.abilities.keyword.FlashAbility;
import mage.cards.Card;
import mage.constants.CommanderCardType;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.game.Game;
import mage.players.Player;

class TeferiMageOfZhalfirAddFlashEffect
extends ContinuousEffectImpl {
    TeferiMageOfZhalfirAddFlashEffect() {
        super(Duration.WhileOnBattlefield, Layer.AbilityAddingRemovingEffects_6, SubLayer.NA, Outcome.AddAbility);
        this.staticText = "Creature cards you own that aren't on the battlefield have flash";
    }

    private TeferiMageOfZhalfirAddFlashEffect(TeferiMageOfZhalfirAddFlashEffect effect) {
        super((ContinuousEffectImpl)effect);
    }

    public TeferiMageOfZhalfirAddFlashEffect copy() {
        return new TeferiMageOfZhalfirAddFlashEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            Card card2;
            for (UUID cardId : controller.getGraveyard()) {
                card2 = game.getCard(cardId);
                if (card2 == null || !card2.isCreature(game)) continue;
                game.getState().addOtherAbility(card2, (Ability)FlashAbility.getInstance());
            }
            for (UUID cardId : controller.getHand()) {
                card2 = game.getCard(cardId);
                if (card2 == null || !card2.isCreature(game)) continue;
                game.getState().addOtherAbility(card2, (Ability)FlashAbility.getInstance());
            }
            for (Card card3 : game.getState().getExile().getCardsOwned(game, controller.getId())) {
                if (!card3.isCreature(game)) continue;
                game.getState().addOtherAbility(card3, (Ability)FlashAbility.getInstance());
            }
            for (Card card3 : controller.getLibrary().getCards(game)) {
                if (!card3.isCreature(game)) continue;
                game.getState().addOtherAbility(card3, (Ability)FlashAbility.getInstance());
            }
            game.getCommanderCardsFromCommandZone(controller, CommanderCardType.ANY).stream().filter(card1 -> card1.isCreature(game)).forEach(card -> game.getState().addOtherAbility(card, (Ability)FlashAbility.getInstance()));
            return true;
        }
        return false;
    }
}

