/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import java.util.UUID;
import mage.ObjectColor;
import mage.abilities.Ability;
import mage.abilities.effects.RestrictionEffect;
import mage.abilities.keyword.FlyingAbility;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;

class TeferisMoatRestrictionEffect
extends RestrictionEffect {
    TeferisMoatRestrictionEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Benefit);
        this.staticText = "Creatures of the chosen color without flying can't attack you";
    }

    private TeferisMoatRestrictionEffect(TeferisMoatRestrictionEffect effect) {
        super((RestrictionEffect)effect);
    }

    public boolean applies(Permanent permanent, Ability source, Game game) {
        ObjectColor chosenColor = (ObjectColor)game.getState().getValue(source.getSourceId() + "_color");
        return chosenColor != null && !permanent.getAbilities().contains((Ability)FlyingAbility.getInstance()) && permanent.getColor(game).shares(chosenColor) && permanent.isCreature(game);
    }

    public boolean canAttack(Permanent attacker, UUID defenderId, Ability source, Game game, boolean canUseChooseDialogs) {
        if (defenderId == null) {
            return true;
        }
        return !defenderId.equals(source.getControllerId());
    }

    public TeferisMoatRestrictionEffect copy() {
        return new TeferisMoatRestrictionEffect(this);
    }
}

