/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.game.stack.StackObject;

class TeferisResponseEffect
extends OneShotEffect {
    public TeferisResponseEffect() {
        super(Outcome.Detriment);
        this.staticText = "Counter target spell or ability an opponent controls that targets a land you control. If a permanent's ability is countered this way, destroy that permanent";
    }

    private TeferisResponseEffect(TeferisResponseEffect effect) {
        super((OneShotEffect)effect);
    }

    public TeferisResponseEffect copy() {
        return new TeferisResponseEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        UUID targetId = source.getFirstTarget();
        StackObject stackObject = game.getStack().getStackObject(targetId);
        if (targetId != null && game.getStack().counter(targetId, source, game)) {
            Permanent usedPermanent;
            UUID permanentId = stackObject.getSourceId();
            if (permanentId != null && (usedPermanent = game.getPermanent(permanentId)) != null) {
                usedPermanent.destroy(source, game, false);
            }
            return true;
        }
        return false;
    }
}

