/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;

class TeleminPerformanceEffect
extends OneShotEffect {
    TeleminPerformanceEffect() {
        super(Outcome.PutCreatureInPlay);
        this.staticText = "Target opponent reveals cards from the top of their library until they reveal a creature card. That player puts all noncreature cards revealed this way into their graveyard, then you put the creature card onto the battlefield under your control";
    }

    private TeleminPerformanceEffect(TeleminPerformanceEffect effect) {
        super((OneShotEffect)effect);
    }

    public TeleminPerformanceEffect copy() {
        return new TeleminPerformanceEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            Player opponent = game.getPlayer(this.getTargetPointer().getFirst(game, source));
            if (opponent != null) {
                Card creature = null;
                CardsImpl nonCreatures = new CardsImpl();
                CardsImpl reveal = new CardsImpl();
                for (Card card : opponent.getLibrary().getCards(game)) {
                    reveal.add(card);
                    if (card.isCreature(game)) {
                        creature = card;
                        break;
                    }
                    nonCreatures.add(card);
                }
                opponent.revealCards(source, (Cards)reveal, game);
                opponent.moveCards((Cards)nonCreatures, Zone.GRAVEYARD, source, game);
                if (creature != null) {
                    game.processAction();
                    controller.moveCards(creature, Zone.BATTLEFIELD, source, game);
                }
            }
            return true;
        }
        return false;
    }
}

