/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.game.Game;
import mage.players.Player;
import mage.target.TargetCard;

class TellingTimeEffect
extends OneShotEffect {
    TellingTimeEffect() {
        super(Outcome.DrawCard);
        this.staticText = "Look at the top three cards of your library. Put one of those cards into your hand, one on top of your library, and one on the bottom of your library.";
    }

    private TellingTimeEffect(TellingTimeEffect effect) {
        super((OneShotEffect)effect);
    }

    public TellingTimeEffect copy() {
        return new TellingTimeEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        MageObject sourceObject = source.getSourceObject(game);
        if (controller == null || sourceObject == null) {
            return false;
        }
        CardsImpl cards = new CardsImpl(controller.getLibrary().getTopCards(game, 3));
        controller.lookAtCards(sourceObject.getIdName(), (Cards)cards, game);
        if (cards.isEmpty()) {
            return true;
        }
        Card card = this.pickCard(controller, (Cards)cards, "card to put in your hand", source, game);
        if (card != null) {
            controller.moveCards(card, Zone.HAND, source, game);
            cards.remove(card);
        }
        if (cards.isEmpty()) {
            return true;
        }
        card = this.pickCard(controller, (Cards)cards, "card to put on top of your library", source, game);
        if (card != null) {
            controller.moveCards(card, Zone.LIBRARY, source, game);
            cards.remove(card);
        }
        if (!cards.isEmpty()) {
            controller.putCardsOnBottomOfLibrary((Cards)cards, game, source, false);
        }
        return true;
    }

    private Card pickCard(Player player, Cards cards, String message, Ability source, Game game) {
        Card card;
        if (cards.isEmpty()) {
            return null;
        }
        if (cards.size() == 1) {
            Card card2 = cards.getRandom(game);
            cards.remove(card2);
            return card2;
        }
        TargetCard target = new TargetCard(Zone.LIBRARY, new FilterCard(message));
        if (player.choose(Outcome.Benefit, cards, target, source, game) && (card = cards.get(target.getFirstTarget(), game)) != null) {
            cards.remove(card);
            return card;
        }
        return null;
    }
}

