/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.filter.FilterCard;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetCardInHand;

class TempleOfTheDragonQueenEffect
extends OneShotEffect {
    private static final FilterCard filter = new FilterCard(SubType.DRAGON);

    public TempleOfTheDragonQueenEffect() {
        super(Outcome.Tap);
        this.staticText = "you may reveal a Dragon card from your hand. {this} enters tapped unless you revealed a Dragon card this way or you control a Dragon";
    }

    private TempleOfTheDragonQueenEffect(TempleOfTheDragonQueenEffect effect) {
        super((OneShotEffect)effect);
    }

    public TempleOfTheDragonQueenEffect copy() {
        return new TempleOfTheDragonQueenEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent land = source.getSourcePermanentIfItStillExists(game);
        if (land == null) {
            land = game.getPermanentEntering(source.getSourceId());
        }
        if (land != null) {
            boolean entersTapped = true;
            Player controller = game.getPlayer(source.getControllerId());
            if (controller != null) {
                Card card;
                TargetCardInHand target;
                boolean dragonInHand = false;
                for (UUID cardId : controller.getHand()) {
                    Card card2 = game.getCard(cardId);
                    if (card2 == null || !card2.hasSubtype(SubType.DRAGON, game)) continue;
                    dragonInHand = true;
                    break;
                }
                if (dragonInHand && controller.chooseUse(Outcome.Untap, "Reveal a Dragon card from your hand?", source, game) && controller.chooseTarget(Outcome.Untap, (Target)(target = new TargetCardInHand(filter)), source, game) && (card = game.getCard(target.getFirstTarget())) != null && card.hasSubtype(SubType.DRAGON, game)) {
                    controller.revealCards(source, (Cards)new CardsImpl(card), game);
                    entersTapped = false;
                }
                if (entersTapped) {
                    for (Permanent permanent : game.getBattlefield().getAllActivePermanents(controller.getId())) {
                        if (permanent == null || !permanent.hasSubtype(SubType.DRAGON, game)) continue;
                        entersTapped = false;
                        break;
                    }
                }
            }
            if (entersTapped) {
                land.setTapped(true);
                return true;
            }
        }
        return false;
    }
}

