/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;

class TemporalDistortionRemovalEffect
extends OneShotEffect {
    TemporalDistortionRemovalEffect() {
        super(Outcome.Neutral);
        this.staticText = "remove all hourglass counters from permanents that player controls";
    }

    private TemporalDistortionRemovalEffect(TemporalDistortionRemovalEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        for (Permanent permanent : game.getBattlefield().getAllActivePermanents(game.getActivePlayerId())) {
            permanent.removeAllCounters(CounterType.HOURGLASS.getName(), source, game);
        }
        return true;
    }

    public TemporalDistortionRemovalEffect copy() {
        return new TemporalDistortionRemovalEffect(this);
    }
}

