/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.token.RabbitToken;
import mage.players.Player;

class TemptWithBunniesEffect
extends OneShotEffect {
    TemptWithBunniesEffect() {
        super(Outcome.PutLandInPlay);
        this.staticText = "draw a card and create a 1/1 white Rabbit creature token. Then each opponent may draw a card and create a 1/1 white Rabbit creature token. For each opponent who does, you draw a card and you create a 1/1 white Rabbit creature token.";
    }

    private TemptWithBunniesEffect(TemptWithBunniesEffect effect) {
        super((OneShotEffect)effect);
    }

    public TemptWithBunniesEffect copy() {
        return new TemptWithBunniesEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            controller.drawCards(1, source, game);
            RabbitToken tokenCopy = new RabbitToken();
            tokenCopy.putOntoBattlefield(1, game, source, source.getControllerId(), false, false);
            int opponentsAddedTokens = 0;
            for (UUID playerId : game.getOpponents(controller.getId())) {
                Player opponent = game.getPlayer(playerId);
                if (opponent == null || !opponent.chooseUse(this.outcome, "Draw a card and create a Rabbit token?", source, game)) continue;
                opponent.drawCards(1, source, game);
                ++opponentsAddedTokens;
                tokenCopy.putOntoBattlefield(1, game, source, playerId, false, false);
            }
            if (opponentsAddedTokens > 0) {
                controller.drawCards(opponentsAddedTokens, source, game);
                tokenCopy.putOntoBattlefield(opponentsAddedTokens, game, source, source.getControllerId(), false, false);
            }
            return true;
        }
        return false;
    }
}

