/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import java.util.LinkedHashSet;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.common.FilterLandCard;
import mage.game.Game;
import mage.players.Player;
import mage.target.common.TargetCardInLibrary;

class TemptWithDiscoveryEffect
extends OneShotEffect {
    TemptWithDiscoveryEffect() {
        super(Outcome.PutLandInPlay);
        this.staticText = "<i>Tempting offer</i> &mdash; Search your library for a land card and put it onto the battlefield. Each opponent may search their library for a land card and put it onto the battlefield. For each opponent who searches a library this way, search your library for a land card and put it onto the battlefield. Then each player who searched a library this way shuffles";
    }

    private TemptWithDiscoveryEffect(TemptWithDiscoveryEffect effect) {
        super((OneShotEffect)effect);
    }

    public TemptWithDiscoveryEffect copy() {
        return new TemptWithDiscoveryEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            LinkedHashSet<UUID> playersShuffle = new LinkedHashSet<UUID>();
            playersShuffle.add(controller.getId());
            TargetCardInLibrary target = new TargetCardInLibrary((FilterCard)new FilterLandCard());
            if (controller.searchLibrary(target, source, game)) {
                for (UUID cardId : target.getTargets()) {
                    Card card = game.getCard(cardId);
                    if (card == null) continue;
                    controller.moveCards(card, Zone.BATTLEFIELD, source, game);
                }
            }
            int opponentsUsedSearch = 0;
            for (UUID playerId : game.getOpponents(controller.getId())) {
                Player opponent = game.getPlayer(playerId);
                if (opponent == null || !opponent.chooseUse(this.outcome, "Search your library for a land card and put it onto the battlefield?", source, game)) continue;
                target.clearChosen();
                ++opponentsUsedSearch;
                playersShuffle.add(playerId);
                if (!opponent.searchLibrary(target, source, game)) continue;
                for (UUID cardId : target.getTargets()) {
                    Card card = game.getCard(cardId);
                    if (card == null) continue;
                    opponent.moveCards(card, Zone.BATTLEFIELD, source, game);
                }
            }
            if (opponentsUsedSearch > 0 && controller.searchLibrary(target = new TargetCardInLibrary(0, opponentsUsedSearch, (FilterCard)new FilterLandCard()), source, game)) {
                for (UUID cardId : target.getTargets()) {
                    Card card = game.getCard(cardId);
                    if (card == null) continue;
                    controller.moveCards(card, Zone.BATTLEFIELD, source, game);
                }
            }
            for (UUID playerId : playersShuffle) {
                Player player = game.getPlayer(playerId);
                if (player == null) continue;
                player.shuffleLibrary(source, game);
            }
            return true;
        }
        return false;
    }
}

