/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.filter.common.FilterCreatureCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.card.OwnerIdPredicate;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetCardInGraveyard;
import mage.target.common.TargetCardInYourGraveyard;

class TemptWithImmortalityEffect
extends OneShotEffect {
    TemptWithImmortalityEffect() {
        super(Outcome.PutCreatureInPlay);
        this.staticText = "<i>Tempting offer</i> &mdash; Return a creature card from your graveyard to the battlefield. Each opponent may return a creature card from their graveyard to the battlefield. For each opponent who does, return a creature card from your graveyard to the battlefield";
    }

    private TemptWithImmortalityEffect(TemptWithImmortalityEffect effect) {
        super((OneShotEffect)effect);
    }

    public TemptWithImmortalityEffect copy() {
        return new TemptWithImmortalityEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            this.returnCreatureFromGraveToBattlefield(controller, source, game);
            int opponentsReturnedCreatures = 0;
            for (UUID playerId : game.getOpponents(controller.getId())) {
                Card card;
                Player opponent = game.getPlayer(playerId);
                if (opponent == null) continue;
                FilterCreatureCard filter = new FilterCreatureCard("creature card from your graveyard");
                filter.add((Predicate)new OwnerIdPredicate(opponent.getId()));
                TargetCardInGraveyard targetCardOpponent = new TargetCardInGraveyard((FilterCard)filter);
                if (!targetCardOpponent.canChoose(opponent.getId(), source, game) || !opponent.chooseUse(this.outcome, "Return a creature card from your graveyard to the battlefield?", source, game) || !opponent.chooseTarget(this.outcome, (Target)targetCardOpponent, source, game) || (card = game.getCard(targetCardOpponent.getFirstTarget())) == null) continue;
                ++opponentsReturnedCreatures;
                opponent.moveCards(card, Zone.BATTLEFIELD, source, game);
            }
            if (opponentsReturnedCreatures > 0) {
                for (int i = 0; i < opponentsReturnedCreatures; ++i) {
                    this.returnCreatureFromGraveToBattlefield(controller, source, game);
                }
            }
            return true;
        }
        return false;
    }

    private boolean returnCreatureFromGraveToBattlefield(Player player, Ability source, Game game) {
        Card card;
        TargetCardInYourGraveyard target = new TargetCardInYourGraveyard((FilterCard)StaticFilters.FILTER_CARD_CREATURE);
        target.withNotTarget(true);
        if (target.canChoose(source.getControllerId(), source, game) && player.chooseTarget(this.outcome, (Target)target, source, game) && (card = game.getCard(target.getFirstTarget())) != null) {
            return player.moveCards(card, Zone.BATTLEFIELD, source, game);
        }
        return false;
    }
}

