/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.common.SimpleStaticAbility;
import mage.abilities.condition.Condition;
import mage.abilities.condition.common.PermanentsOnTheBattlefieldCondition;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.UntapTargetEffect;
import mage.abilities.effects.common.continuous.GainAbilityTargetEffect;
import mage.abilities.effects.common.continuous.GainControlTargetEffect;
import mage.abilities.effects.common.cost.SpellCostReductionSourceEffect;
import mage.abilities.hint.ConditionHint;
import mage.abilities.hint.Hint;
import mage.abilities.keyword.HasteAbility;
import mage.abilities.keyword.MenaceAbility;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.Duration;
import mage.constants.Zone;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.AbilityPredicate;
import mage.target.Target;
import mage.target.common.TargetCreaturePermanent;

public final class TentativeConnection
extends CardImpl {
    private static final FilterPermanent filter = new FilterControlledCreaturePermanent("you control a creature with menace");

    public TentativeConnection(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.SORCERY}, "{3}{R}");
        PermanentsOnTheBattlefieldCondition condition = new PermanentsOnTheBattlefieldCondition(filter);
        SimpleStaticAbility ability = new SimpleStaticAbility(Zone.ALL, (Effect)new SpellCostReductionSourceEffect(3, (Condition)condition));
        ability.setRuleAtTheTop(true);
        ability.addHint((Hint)new ConditionHint((Condition)condition, "You control a creature with menace"));
        this.addAbility((Ability)ability);
        this.getSpellAbility().addTarget((Target)new TargetCreaturePermanent());
        this.getSpellAbility().addEffect((Effect)new GainControlTargetEffect(Duration.EndOfTurn));
        this.getSpellAbility().addEffect((Effect)new UntapTargetEffect().setText("Untap that creature"));
        this.getSpellAbility().addEffect((Effect)new GainAbilityTargetEffect((Ability)HasteAbility.getInstance(), Duration.EndOfTurn).setText("It gains haste until end of turn."));
    }

    private TentativeConnection(TentativeConnection card) {
        super((CardImpl)card);
    }

    public TentativeConnection copy() {
        return new TentativeConnection(this);
    }

    static {
        filter.add((Predicate)new AbilityPredicate(MenaceAbility.class));
    }
}

